<?php
session_start();
include '../admin/config/db.php';

$api_key = "API_KEY_خودت"; // API Key IDPay

// اگر IDPay چیزی ارسال نکرده بود
if (!isset($_POST['id']) || !isset($_POST['order_id'])) {
    echo "اطلاعات پرداخت ارسال نشده است.";
    exit;
}

$id = $_POST['id'];
$order_id = $_POST['order_id'];

// داده برای تایید پرداخت
$data = [
    "id" => $id,
    "order_id" => $order_id
];

// ارسال درخواست تایید
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.idpay.ir/v1.1/payment/verify");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "X-API-KEY: $api_key",
    "X-SANDBOX: 1" // بعداً 0 کن
]);

$result = curl_exec($ch);
curl_close($ch);

$result = json_decode($result, true);

// اگر پرداخت موفق بود
if ($result["status"] == 100) {

    // اطلاعات سفارش از سشن
    $info = $_SESSION['order_info'];
    $total_price = $_SESSION['total_price'];
    $user_id = $_SESSION['user_id'];

    // ثبت سفارش در دیتابیس
    $stmt = $pdo->prepare("
        INSERT INTO orders (user_id, fname, lname, phone, province, city, address, total_price, status)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, 'پرداخت شده')
    ");

    $stmt->execute([
        $user_id,
        $info['fname'],
        $info['lname'],
        $info['phone'],
        $info['province'],
        $info['city'],
        $info['address'],
        $total_price
    ]);

    $new_order_id = $pdo->lastInsertId();

    // ثبت محصولات سفارش
    foreach ($_SESSION['cart'] as $product_id => $qty) {

        $stmt = $pdo->prepare("SELECT final_price FROM products WHERE id = ?");
        $stmt->execute([$product_id]);
        $price = $stmt->fetchColumn();

        $pdo->prepare("
            INSERT INTO order_items (order_id, product_id, quantity, price)
            VALUES (?, ?, ?, ?)
        ")->execute([$new_order_id, $product_id, $qty, $price]);
    }

    // خالی کردن سبد و اطلاعات سفارش
    unset($_SESSION['cart']);
    unset($_SESSION['order_info']);
    unset($_SESSION['total_price']);

    // نمایش رسید پرداخت
    ?>
    <!DOCTYPE html>
    <html lang="fa" dir="rtl">
    <head>
        <meta charset="UTF-8">
        <title>رسید پرداخت</title>
        <style>
            body {
                background: #f5f5f5;
                font-family: "IRANSans", sans-serif;
            }
            .box {
                max-width: 600px;
                margin: 60px auto;
                background: #fff;
                padding: 35px;
                border-radius: 18px;
                text-align: center;
                box-shadow: 0 0 25px rgba(0,0,0,0.1);
            }
            .box h2 {
                color: #28a745;
                font-size: 28px;
                margin-bottom: 15px;
            }
            .order-id {
                font-size: 22px;
                font-weight: bold;
                background: #eee;
                padding: 10px 20px;
                border-radius: 10px;
                display: inline-block;
                margin: 15px 0;
            }
            a.btn {
                display: inline-block;
                margin-top: 15px;
                padding: 12px 25px;
                border-radius: 10px;
                text-decoration: none;
                font-size: 17px;
                background: #007bff;
                color: #fff;
            }
        </style>
    </head>
    <body>

    <div class="box">
        <h2>پرداخت با موفقیت انجام شد</h2>
        <p>سفارش شما ثبت شد</p>

        <p>شماره سفارش:</p>
        <div class="order-id">#<?= $new_order_id ?></div>

        <a href="index.php" class="btn">بازگشت به صفحه اصلی</a>
    </div>

    </body>
    </html>

    <?php
    exit;

} else {
    echo "پرداخت ناموفق بود";
    exit;
}