<?php
include '../admin/config/db.php';

$order = null;

if (isset($_POST['order_id'])) {
    $order_id = $_POST['order_id'];

    $stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
    $stmt->execute([$order_id]);
    $order = $stmt->fetch();
}
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>پیگیری سفارش</title>

<style>
body {
    background: #f5f5f5;
    font-family: "IRANSans", sans-serif;
}

.track-container {
    max-width: 600px;
    margin: 50px auto;
    background: #ffffff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(0,0,0,0.1);
}

.track-container h2 {
    text-align: center;
    margin-bottom: 25px;
    font-size: 26px;
    font-weight: bold;
}

.track-container label {
    font-weight: bold;
    margin-top: 10px;
    display: block;
}

.track-container input {
    width: 100%;
    padding: 12px;
    border-radius: 10px;
    border: 1px solid #ccc;
    margin-top: 5px;
    font-size: 16px;
}

.track-btn {
    width: 100%;
    background: #007bff;
    color: #fff;
    padding: 12px;
    border-radius: 10px;
    font-size: 18px;
    margin-top: 20px;
    border: none;
    cursor: pointer;
    transition: 0.2s;
}

.track-btn:hover {
    opacity: 0.85;
}

.order-box {
    margin-top: 30px;
    background: #ffffff;
    padding: 25px;
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(0,0,0,0.08);
}

.order-box h3 {
    font-size: 22px;
    margin-bottom: 15px;
    color: #28a745;
}

.order-box p {
    font-size: 18px;
    margin: 8px 0;
}

.status {
    padding: 8px 15px;
    background: #ffc107;
    border-radius: 8px;
    display: inline-block;
    font-weight: bold;
}

.status.sent {
    background: #28a745;
    color: #fff;
}

.status.packing {
    background: #17a2b8;
    color: #fff;
}

.status.waiting {
    background: #ffc107;
    color: #000;
}
</style>

</head>
<body>

<div class="track-container">

    <h2>پیگیری سفارش</h2>

    <form method="POST">
        <label>شماره سفارش</label>
        <input type="text" name="order_id" placeholder="مثال: 1254" required>

        <button class="track-btn" type="submit">جستجو</button>
    </form>

    <?php if ($order): ?>

        <div class="order-box">
            <h3>نتیجه پیگیری سفارش</h3>

            <p><strong>نام مشتری:</strong> 
                <?php echo $order['fname'] . ' ' . $order['lname']; ?>
            </p>

            <p><strong>مبلغ کل:</strong> 
                <?php echo number_format($order['total_price']); ?> تومان
            </p>

            <p><strong>وضعیت سفارش:</strong> 
                <span class="status 
                    <?php 
                        if ($order['status'] == 'ارسال شده') echo 'sent';
                        elseif ($order['status'] == 'بسته بندی') echo 'packing';
                        else echo 'waiting';
                    ?>
                ">
                    <?php echo $order['status']; ?>
                </span>
            </p>

            <p><strong>استان:</strong> <?php echo $order['province']; ?></p>
            <p><strong>شهر:</strong> <?php echo $order['city']; ?></p>
            <p><strong>آدرس:</strong> <?php echo $order['address']; ?></p>
        </div>

    <?php elseif (isset($_POST['order_id'])): ?>

        <div class="order-box">
            <h3 style="color:red;">سفارشی با این شماره یافت نشد</h3>
            <p>لطفاً شماره سفارش را بررسی کنید.</p>
        </div>

    <?php endif; ?>

</div>

</body>
</html>