<?php
session_start();
include '../admin/config/db.php';

// اگر سبد خالی بود
if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
    header("Location: cart.php");
    exit;
}

// گرفتن اطلاعات فرم
$_SESSION['order_info'] = [
    'fname'    => $_POST['fname'],
    'lname'    => $_POST['lname'],
    'phone'    => $_POST['phone'],
    'province' => $_POST['province'],
    'city'     => $_POST['city'],
    'address'  => $_POST['address']
];

// محاسبه قیمت کل
$total_price = 0;

foreach ($_SESSION['cart'] as $product_id => $qty) {
    $stmt = $pdo->prepare("SELECT final_price FROM products WHERE id = ?");
    $stmt->execute([$product_id]);
    $price = $stmt->fetchColumn();
    $total_price += ($price * $qty);
}

// ذخیره مبلغ کل در سشن
$_SESSION['total_price'] = $total_price;

// هدایت به صفحه پرداخت
header("Location: payment.php");
exit;
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ثبت سفارش</title>

<style>
body {
    background: #f5f5f5;
    font-family: "IRANSans", sans-serif;
}

.success-box {
    max-width: 600px;
    margin: 60px auto;
    background: #ffffff;
    padding: 35px;
    border-radius: 18px;
    text-align: center;
    box-shadow: 0 0 25px rgba(0,0,0,0.1);
}

.success-box h2 {
    font-size: 28px;
    color: #28a745;
    margin-bottom: 15px;
    font-weight: bold;
}

.success-box p {
    font-size: 18px;
    margin: 10px 0;
}

.order-id {
    font-size: 22px;
    font-weight: bold;
    color: #333;
    background: #f1f1f1;
    padding: 10px 20px;
    border-radius: 10px;
    display: inline-block;
    margin: 15px 0;
}

.success-btn,
.track-btn {
    display: inline-block;
    margin-top: 15px;
    padding: 12px 25px;
    border-radius: 10px;
    text-decoration: none;
    font-size: 17px;
    transition: 0.2s;
    color: #fff;
}

.success-btn {
    background: #007bff;
}

.track-btn {
    background: #28a745;
}

.success-btn:hover,
.track-btn:hover {
    opacity: 0.85;
}
</style>

</head>
<body>

<div class="success-box">
    <h2>سفارش شما با موفقیت ثبت شد</h2>
    <p>از خرید شما سپاسگزاریم</p>

    <p>شماره سفارش شما:</p>
    <div class="order-id">#<?php echo $order_id; ?></div>

    <p>برای پیگیری وضعیت سفارش، شماره سفارش را نزد خود نگه دارید.</p>

    <a href="index.php" class="success-btn">بازگشت به صفحه اصلی</a>
    <a href="track.php" class="track-btn">پیگیری سفارش</a>
</div>

</body>
</html>