<?php
session_start();
require '../admin/config/db.php';

$err = "";
$success = "";

if (isset($_POST['register'])) {

    $fullname = trim($_POST['fullname']);
    $email = trim($_POST['email']);
    $phone = trim($_POST['phone']);
    $pass = trim($_POST['password']);

    // چک خالی نبودن
    if ($fullname == "" || $email == "" || $phone == "" || $pass == "") {
        $err = "لطفاً همه فیلدها را پر کنید.";
    } else {

        // چک تکراری نبودن ایمیل یا شماره موبایل
        $check = $pdo->prepare("SELECT id FROM users WHERE email = ? OR phone = ?");
        $check->execute([$email, $phone]);

        if ($check->rowCount() > 0) {
            // اگر کاربر قبلاً ثبت‌نام کرده بود → بفرست به صفحه ورود
            header("Location: login.php?exists=1");
            exit;
        } else {

            // رمزنگاری پسورد
            $hashed = password_hash($pass, PASSWORD_DEFAULT);

            // ذخیره کاربر
            $stmt = $pdo->prepare("INSERT INTO users (full_name, email, phone, password, role) VALUES (?, ?, ?, ?, 'user')");
            $stmt->execute([$fullname, $email, $phone, $hashed]);

            // ورود خودکار
            $_SESSION['user_id'] = $pdo->lastInsertId();
            $_SESSION['user_name'] = $fullname;
            $_SESSION['role'] = "user";

            header("Location: index.php");
            exit;
        }
    }
}
?>

<?php include 'includes/header.php'; ?>

<div class="register-box">

    <h2>ثبت نام</h2>

    <?php if ($err): ?>
        <div class="error-box"><?php echo $err; ?></div>
    <?php endif; ?>

    <form method="post">

        <label>نام و نام خانوادگی</label>
        <input type="text" name="fullname">

        <label>ایمیل</label>
        <input type="email" name="email">

        <label>شماره موبایل</label>
        <input type="text" name="phone">

        <label>رمز عبور</label>
        <input type="password" name="password">

        <button type="submit" name="register" class="btn">ثبت نام</button>

    </form>

    <p style="margin-top:15px; text-align:center;">
        قبلاً ثبت‌نام کرده‌اید؟  
        <a href="login.php" style="color:#d4af37; font-weight:bold;">ورود به حساب</a>
    </p>

</div>

<?php include 'includes/footer.php'; ?>