<?php
session_start();
include '../admin/config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = (int)$_SESSION['user_id'];

// گرفتن اطلاعات کاربر
$user_stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$user_stmt->execute([$user_id]);
$user = $user_stmt->fetch(PDO::FETCH_ASSOC);

// اگر کاربر پیدا نشد
if (!$user) {
    echo "کاربر یافت نشد.";
    exit;
}

// گرفتن آدرس‌ها
$addr_stmt = $pdo->prepare("SELECT * FROM addresses WHERE user_id = ? ORDER BY id DESC");
$addr_stmt->execute([$user_id]);
$addresses = $addr_stmt->fetchAll(PDO::FETCH_ASSOC);

// گرفتن سفارش‌ها
$order_stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY id DESC");
$order_stmt->execute([$user_id]);
$orders = $order_stmt->fetchAll(PDO::FETCH_ASSOC);

// گرفتن اعلان‌ها
$notif_stmt = $pdo->prepare("SELECT * FROM notifications WHERE user_id = ? ORDER BY id DESC");
$notif_stmt->execute([$user_id]);
$notifications = $notif_stmt->fetchAll(PDO::FETCH_ASSOC);

// جلوگیری از خطا اگر ستون وجود نداشت
$name   = htmlspecialchars($user['name']   ?? '');
$email  = htmlspecialchars($user['email']  ?? '');
$phone  = htmlspecialchars($user['phone']  ?? '');
$joined = $user['created_at'] ?? '';
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<title>پنل کاربری</title>
<style>
body { background:#000; color:#fff; font-family:Tahoma; direction:rtl; margin:0; }
.dashboard { width:80%; margin:80px auto; }
.dashboard h2 { color:#FFD700; margin-top:40px; }
.box { background:#111; padding:20px; border-radius:10px; box-shadow:0 0 10px #FFD700; margin-top:10px; }
.item { background:#222; padding:10px; margin:5px 0; border-radius:6px; }
.btn { display:inline-block; padding:8px 15px; background:#FFD700; color:#000; border-radius:6px; text-decoration:none; margin-top:10px; }
.status { color:#FFD700; }
.top-bar { position:fixed; top:0; right:0; left:0; height:60px; background:#111; display:flex; align-items:center; justify-content:space-between; padding:0 30px; box-shadow:0 0 10px #000; z-index:9999; }
</style>
</head>
<body>

<div class="top-bar">
    <div>پنل کاربری</div>

    <div style="display:flex; align-items:center; gap:15px;">

        <!-- دکمه رفتن به سبد خرید -->
        <a href="cart.php" 
           style="background:#FFD700; color:#000; padding:8px 15px; border-radius:8px; 
                  text-decoration:none; font-weight:bold;">
            🛒 رفتن به سبد خرید
        </a>

        <!-- نام کاربر -->
        <span><?= $name ?></span>

        <!-- خروج -->
       
    </div>
</div>
<div class="dashboard">

    <h2>پروفایل من</h2>
    <div class="box">
        <p><strong>نام:</strong> <?= $name ?></p>
        <p><strong>ایمیل:</strong> <?= $email ?></p>
        <p><strong>شماره تماس:</strong> <?= $phone ?></p>
        <p><strong>تاریخ عضویت:</strong> <?= $joined ?></p>
        <a class="btn" href="edit_profile.php">ویرایش پروفایل</a>
    </div>

    <h2>آدرس‌های من</h2>
    <div class="box">
        <?php if (count($addresses) === 0): ?>
            <p>هنوز آدرسی ثبت نکرده‌اید.</p>
        <?php endif; ?>

        <?php foreach ($addresses as $a): ?>
            <div class="item">
                <?= nl2br(htmlspecialchars($a['address'] ?? '')) ?>
            </div>
        <?php endforeach; ?>

        <a class="btn" href="add_address.php">افزودن آدرس جدید</a>
    </div>

    <h2>سفارش‌های من</h2>
    <div class="box">
        <?php if (count($orders) === 0): ?>
            <p>هنوز سفارشی ثبت نکرده‌اید.</p>
        <?php endif; ?>

        <?php foreach ($orders as $o): ?>
            <div class="item">
                سفارش #<?= $o['id'] ?> —
                <span class="status"><?= htmlspecialchars($o['status'] ?? '') ?></span> —
                مبلغ: <?= number_format($o['total_price'] ?? 0) ?> تومان —
                تاریخ: <?= $o['created_at'] ?? '' ?>
            </div>
        <?php endforeach; ?>
    </div>

    <h2>اعلان‌ها</h2>
    <div class="box">
        <?php if (count($notifications) === 0): ?>
            <p>اعلانی برای شما ثبت نشده است.</p>
        <?php endif; ?>

        <?php foreach ($notifications as $n): ?>
            <div class="item">
                <?= nl2br(htmlspecialchars($n['message'] ?? '')) ?> <br>
                <small><?= $n['created_at'] ?? '' ?></small>
            </div>
        <?php endforeach; ?>
    </div>

</div>