<?php include 'includes/header.php'; ?>
<?php include '../admin/config/db.php'; ?>
<style>
/* دسکتاپ → گرید */
.products-wrapper {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(230px, 1fr));
    gap: 25px;
    padding: 20px;
}

/* کارت محصول */
.product-card {
    background: #fff;
    border-radius: 18px;
    padding: 15px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.12);
    transition: .3s;
    text-align: center;

    /* مهم برای جلوگیری از بیرون زدن دکمه */
    display: flex;
    flex-direction: column;
    justify-content: space-between;
    height: 100%;
}

.product-card img {
    width: 100%;
    height: 170px;
    object-fit: cover;
    border-radius: 14px;
    margin-bottom: 10px;
}

.product-card h3 {
    font-size: 16px;
    margin: 8px 0;
    min-height: 40px; /* عنوان ثابت */
}

.price {
    color: #d4a017;
    font-weight: bold;
    font-size: 18px;
    margin: 8px 0;
}

/* دکمه همیشه داخل کارت */
.btn {
    margin-top: auto;
    padding: 10px 18px;
    background: linear-gradient(135deg, #d4a017, #b88a12);
    color: #fff;
    border-radius: 10px;
    text-decoration: none;
    transition: .3s;
}

.btn:hover {
    transform: translateY(-3px);
}

/* 📱 موبایل → دو تا دو تا کنار هم */
@media (max-width: 768px) {

    .products-wrapper {
        display: grid;
        grid-template-columns: repeat(2, 1fr); /* دو تا دو تا */
        gap: 15px;
        padding: 10px;
    }

    .product-card {
        min-width: unset; /* مهم */
    }

    .product-card img {
        height: 140px;
    }

    .btn {
        font-size: 13px;
        padding: 8px 14px;
    }
}
 </style>

<h2 class="section-title">همه محصولات</h2>

<div class="section-box">

    <div class="products-wrapper" id="productsWrapper">

        <?php
        $products = $pdo->query("SELECT * FROM products ORDER BY id DESC")->fetchAll();

        foreach ($products as $p):

            $img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
            $img->execute([$p['id']]);
            $image = $img->fetchColumn();

            $price = isset($p['price']) ? (float)$p['price'] : 0;
        ?>

        <div class="product-card">
            <img src="../admin/<?php echo $image; ?>" alt="">
            <h3><?php echo $p['title']; ?></h3>
            <p class="price"><?php echo number_format($price); ?> تومان</p>
            <a class="btn" href="product.php?id=<?php echo $p['id']; ?>">مشاهده</a>
        </div>

        <?php endforeach; ?>

    </div>

</div>

<?php include 'includes/footer.php'; ?>