<?php include 'includes/header.php'; ?>
<?php include '../admin/config/db.php'; ?>

<?php
$id = $_GET['id'];

// گرفتن اطلاعات محصول
$stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
$stmt->execute([$id]);
$p = $stmt->fetch();

// گرفتن عکس‌ها
$imgs = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ?");
$imgs->execute([$id]);
$images = $imgs->fetchAll();

// قیمت امن
$price = !empty($p['final_price']) ? (float)$p['final_price'] : (!empty($p['price']) ? (float)$p['price'] : 0);

// وزن امن
$weight = !empty($p['weight_gram']) ? $p['weight_gram'] : (!empty($p['weight']) ? $p['weight'] : 0);
?>

<div class="product-container">

    <div class="gallery">
        <div class="main-image">
            <img id="bigImage" src="../admin/<?php echo $images[0]['image_path']; ?>">
        </div>

        <div class="thumbs">
            <?php foreach ($images as $img): ?>
                <img class="thumb"
                     src="../admin/<?php echo $img['image_path']; ?>"
                     onclick="document.getElementById('bigImage').src=this.src;">
            <?php endforeach; ?>
        </div>
    </div>

    <div class="info">
        <h2><?php echo $p['title']; ?></h2>

        <!-- قیمت -->
        <p class="price"><?php echo number_format($price); ?> تومان</p>

        <!-- وزن -->
        <p><strong>وزن:</strong> <?php echo $weight; ?> گرم</p>

        <p class="desc"><?php echo nl2br($p['description']); ?></p>

        <form action="cart_add.php" method="POST">
            <input type="hidden" name="product_id" value="<?php echo $p['id']; ?>">
            <a class="buy-btn" href="cart.php?add=<?php echo $p['id']; ?>">افزودن به سبد خرید</a>
        </form>
    </div>

</div>

<?php include 'includes/footer.php'; ?>