<?php
session_start();
include '../admin/config/db.php';

// اگر کاربر لاگین نبود
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// اگر اطلاعات سفارش نبود
if (!isset($_SESSION['order_info']) || !isset($_SESSION['total_price'])) {
    header("Location: cart.php");
    exit;
}

// API Key واقعی را اینجا بگذار
$api_key = "اینجا API KEY واقعی IDPay را بگذار";

// مبلغ کل از سشن
$amount = $_SESSION['total_price'];

// آدرس واقعی verify.php
$callback = "http://localhost/amir100/site/verify.php"; 
// اگر هاست داری، اینو بزن:
// $callback = "https://domain.com/verify.php";

// ساخت داده برای ارسال به IDPay
$data = [
    "order_id" => time(),
    "amount" => $amount * 10,
    "name" => $_SESSION['order_info']['fname'] . " " . $_SESSION['order_info']['lname'],
    "desc" => "پرداخت سفارش طلافروشی",
    "callback" => $callback
];

// ارسال درخواست به IDPay
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.idpay.ir/v1.1/payment");
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
    "X-API-KEY: $api_key",
    "X-SANDBOX: 1" // حالت تستی
]);

$result = curl_exec($ch);
curl_close($ch);

$result = json_decode($result, true);

// اگر لینک پرداخت برگشت داده شد
if (isset($result["link"])) {
    header("Location: " . $result["link"]);
    exit;
} else {
    echo "خطا در اتصال به درگاه پرداخت<br><br>";
    print_r($result); // دلیل خطا را نشان می‌دهد
}
?>