<?php
session_start();
require '../admin/config/db.php';

$err = "";

// اگر کاربر روی دکمه ورود کلیک کرد
if (isset($_POST['login'])) {

    $username = trim($_POST['username']);
    $pass = trim($_POST['password']);

    // گرفتن کاربر بر اساس نام کاربری
    $stmt = $pdo->prepare("SELECT * FROM users WHERE full_name = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    // چک کردن وجود کاربر + درست بودن رمز
    if ($user && password_verify($pass, $user['password'])) {

        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['full_name'];
        $_SESSION['role'] = $user['role'];

        header("Location: index.php");
        exit;

    } else {
        $err = "نام کاربری یا رمز عبور اشتباه است.";
    }
}
?>

<?php include 'includes/header.php'; ?>

<div class="register-box">

    <h2>ورود</h2>

    <?php if (isset($_GET['exists'])): ?>
        <div class="success-box">این حساب قبلاً ثبت شده است، لطفاً وارد شوید.</div>
    <?php endif; ?>

    <?php if ($err): ?>
        <div class="error-box"><?php echo $err; ?></div>
    <?php endif; ?>

    <form method="post">

        <label>نام کاربری</label>
        <input type="text" name="username">

        <label>رمز عبور</label>
        <input type="password" name="password">

        <button type="submit" name="login" class="btn">ورود</button>

    </form>

    <p style="margin-top:15px; text-align:center;">
        حساب ندارید؟  
        <a href="register.php" style="color:#d4af37; font-weight:bold;">ثبت نام</a>
    </p>

</div>

<?php include 'includes/footer.php'; ?>