



<?php include 'includes/header.php'; ?>
<style>
    
/* عنوان بخش‌ها */
.section-title {
    text-align: center;
    font-size: 28px;
    margin: 40px 0 20px;
    color: #d4a017;
    font-weight: bold;
    letter-spacing: 1px;
    text-shadow: 0 0 8px rgba(212,160,23,0.4);
}

/* باکس طلایی */
.section-box {
    background: linear-gradient(135deg, #fff7e6,rgb(255, 255, 255));
    padding: 25px 15px;
    border-radius: 25px;
    box-shadow: 0 0 25px rgba(0,0,0,0.08);
    overflow: hidden;
}

/* اسلایدر بی‌نهایت */
.slider-loop {
    display: flex;
    gap: 25px;
    animation: sliderLoop 22s linear infinite;
    padding: 10px 0;
}

@keyframes sliderLoop {
    0%   { transform: translateX(0); }
    100% { transform: translateX(-50%); }
}

/* کارت محصول */
.product-card {
    min-width: 230px;
    background: #ffffff;
    border-radius: 18px;
    padding: 15px;
    position: relative;
    box-shadow: 0 6px 20px rgba(0,0,0,0.12);
    transition: .35s ease;
    transform: perspective(800px) translateZ(0);
}

.product-card:hover {
    transform: perspective(800px) translateZ(18px) translateY(-8px);
    box-shadow: 0 12px 30px rgba(0,0,0,0.18);
}

/* عکس محصول */
.product-card img {
    width: 100%;
    height: 170px;
    object-fit: cover;
    border-radius: 10px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transition: .3s;
}

.product-card:hover img {
    transform: scale(1.05);
}

/* عنوان محصول */
.product-card h3 {
    font-size: 16px;
    margin: 10px 0 5px;
    color: #333;
    font-weight: bold;
}

/* قیمت */
.price {
    color: #d4a017;
    font-weight: bold;
    font-size: 18px;
    margin: 8px 0;
    text-shadow: 0 0 6px rgba(212,160,23,0.3);
}

/* روبان شگفت‌انگیز */
.ribbon {
    position: absolute;
    top: -12px;
    right: 12px;
    background: linear-gradient(135deg, #ff3b3b, #d40000);
    color: #fff;
    padding: 6px 14px;
    border-radius: 10px;
    font-size: 13px;
    font-weight: bold;
    box-shadow: 0 4px 12px rgba(255,0,0,0.4);
}

/* دکمه‌ها */
.btn {
    display: inline-block;
    padding: 8px 18px;
    background: linear-gradient(135deg, #d4a017, #b88a12);
    color: #fff;
    border-radius: 10px;
    text-decoration: none;
    transition: .3s;
    font-size: 14px;
    font-weight: bold;
}

.btn:hover {
    background: linear-gradient(135deg, #b88a12, #d4a017);
    transform: translateY(-3px);
}

/* دکمه مشاهده همه */
.all-btn {
    display: block;
    width: fit-content;
    margin: 20px auto 0;
    padding: 12px 30px;
    background: #111;
    color: #fff;
    border-radius: 30px;
    text-decoration: none;
    transition: .3s;
    font-size: 15px;
    font-weight: bold;
}

.all-btn:hover {
    background: #d4a017;
    transform: translateY(-3px);
}
.hero-banner {
    width: 100%;
    height: 350px;
    border-radius: 15px;
    overflow: hidden;
    position: relative;
    margin: 25px auto;
    box-shadow: 0 10px 35px rgba(0,0,0,0.15);
}

.hero-banner img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* متن روی بنر */
.hero-text {
    position: absolute;
    bottom: 25px;
    right: 25px;
    background: rgba(0,0,0,0.45);
    padding: 12px 20px;
    border-radius: 12px;
    color: #fff;
    font-size: 22px;
    font-weight: bold;
    backdrop-filter: blur(4px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
}

/* دکمه */
.hero-btn {
    margin-top: 10px;
    display: inline-block;
    padding: 10px 22px;
    background: linear-gradient(135deg, #d4a017, #b88a12);
    color: #fff;
    border-radius: 10px;
    text-decoration: none;
    font-size: 14px;
    font-weight: bold;
    transition: .3s;
}

.hero-btn:hover {
    background: linear-gradient(135deg, #b88a12, #d4a017);
    transform: translateY(-3px);
}

/* 📱 نسخه موبایل */
@media (max-width: 768px) {

    .hero-banner {
        height: 220px; /* کوچیک‌تر و شیک‌تر */
        border-radius: 15px;
    }

    .hero-text {
        bottom: 15px;
        right: 15px;
        padding: 8px 14px;
        font-size: 16px; /* متن کوچیک‌تر */
        border-radius: 10px;
    }

    .hero-btn {
        padding: 7px 16px;
        font-size: 12px;
        border-radius: 8px;
    }
}
</style>

<div class="hero-banner">
    <img src="images/banner.jpg" alt="بنر طلافروشی">

    <div class="hero-text">
        جدیدترین مدل‌های طلا و جواهر
        <br>
        <a href="products.php" class="hero-btn">مشاهده محصولات</a>
    </div>
</div>
<!-- بخش ۱: جدیدترین محصولات -->
<h2 class="section-title">جدیدترین محصولات</h2>

<div class="section-box">
    <div class="slider-loop" id="latestSlider">

        <?php
        $products = $pdo->query("SELECT * FROM products ORDER BY id DESC LIMIT 12")->fetchAll();

        foreach ($products as $p):

            $img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
            $img->execute([$p['id']]);
            $image = $img->fetchColumn();

            $price = isset($p['price']) ? (float)$p['price'] : 0;
        ?>

        <div class="product-card">
            <img src="../admin/<?php echo $image; ?>" alt="">
            <h3><?php echo $p['title']; ?></h3>
            <p class="price"><?php echo number_format($price); ?> تومان</p>
            <a class="btn" href="product.php?id=<?php echo $p['id']; ?>">مشاهده</a>
        </div>

        <?php endforeach; ?>

    </div>

    <a href="products.php" class="all-btn">مشاهده همه محصولات</a>
</div>


<!-- بخش ۲: محصولات شگفت‌انگیز -->
<h2 class="section-title">محصولات شگفت‌انگیز</h2>

<div class="section-box">
    <div class="slider-loop" id="amazingSlider">

        <?php
        $offers = $pdo->query("SELECT * FROM products WHERE is_special = 1 ORDER BY id DESC LIMIT 10")->fetchAll();

        foreach ($offers as $p):

            $img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
            $img->execute([$p['id']]);
            $image = $img->fetchColumn();

            $price = isset($p['price']) ? (float)$p['price'] : 0;
        ?>

        <div class="product-card">
            <div class="ribbon">شگفت‌انگیز</div>
            <img src="../admin/<?php echo $image; ?>" alt="">
            <h3><?php echo $p['title']; ?></h3>
            <p class="price"><?php echo number_format($price); ?> تومان</p>
            <a class="btn" href="product.php?id=<?php echo $p['id']; ?>">مشاهده</a>
        </div>

        <?php endforeach; ?>

    </div>

    <a href="special_offers.php" class="all-btn">مشاهده همه شگفت‌انگیزها</a>
</div>
<script>
document.getElementById("latestSlider").innerHTML += 
    document.getElementById("latestSlider").innerHTML;

document.getElementById("amazingSlider").innerHTML += 
    document.getElementById("amazingSlider").innerHTML;
</script>
<?php include 'includes/footer.php'; ?>