<?php
// همیشه سشن را فعال کن
if (!isset($_SESSION)) {
    session_start();
}

require '../admin/config/db.php';

// گرفتن دسته‌بندی‌ها
$cats = $pdo->query("SELECT * FROM categories")->fetchAll();

// تعداد محصولات داخل سبد خرید
$cart_count = isset($_SESSION['cart']) ? count($_SESSION['cart']) : 0;
?>
<div id="gold-bar" style="
    width:100%;
    height:70px;
    background:#000;
    overflow:hidden;
    position:fixed;
    top:0;
    right:0;
    left:0;
    z-index:99999;
    border-bottom:3px solid #FFD700;
    box-shadow:0 0 20px rgba(255,215,0,0.6);
    display:flex;
    align-items:center;
    padding-right:20px;
    font-family:Tahoma, sans-serif;
    direction:rtl;">
    
    <div id="gold-text" style="
        white-space:nowrap;
        font-size:26px;
        font-weight:bold;
        color:#FFD700;
        text-shadow:0 0 10px #FFD700;
        animation:goldSlide 14s linear infinite;">
        در حال دریافت قیمت لحظه‌ای طلا...
    </div>
</div>

<style>
@keyframes goldSlide {
    0% { transform:translateX(100%); }
    100% { transform:translateX(-100%); }
}

/* جلوگیری از رفتن محتوا زیر نوار */
body {
    padding-top:80px !important;
}
</style>

<script>
function loadGold() {
    fetch("api-gold.php")
        .then(res => res.json())
        .then(data => {
            document.getElementById("gold-text").innerHTML =
                "💰 قیمت لحظه‌ای طلا | " +
                "طلای 24 عیار: " + Number(data.g24).toLocaleString() + " تومان" +
                " | " +
                "طلای 18 عیار: " + Number(data.g18).toLocaleString() + " تومان" +
                " 💰";
        })
        .catch(() => {
            document.getElementById("gold-text").innerHTML =
                "خطا در دریافت قیمت طلا";
        });
}

loadGold();
setInterval(loadGold, 5000);
</script>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>فروشگاه طلاتیارام</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdn.fontcdn.ir/Font/Persian/IRANSans/IRANSans.css" rel="stylesheet">
</head>
<body>

<header class="top-header">
    <div class="header-container">

        <div class="logo">طلا تیارام</div>

        <!-- دکمه موبایل -->
        <div class="mobile-menu-btn" onclick="toggleMenu()">☰</div>

        <nav class="nav-menu" id="navMenu">
            <ul>
                <li><a href="index.php">خانه</a></li>
                <li><a href="register.php">ثبت نام در سایت</a></li>
                <li><a href="special_offers.php">شگفت‌انگیزها</a></li>
                <li><a href="products.php">محصولات</a></li>
                
                <li>
    <a href="profile.php#orders" 
       style="color:#FFD700; font-weight:bold;">
        📦 مدیریت سفارش‌ها
    </a>
</li>
                <li><a href="blog.php">وبلاگ</a></li>

                <?php foreach ($cats as $c): ?>
                    <li><a href="category.php?id=<?php echo $c['id']; ?>">
                        <?php echo $c['name']; ?>
                    </a></li>
                <?php endforeach; ?>
            </ul>
        </nav>

        <div class="cart-box">
            <a href="cart.php">
                🛒
                <span class="cart-text">سبد خرید</span>
                <span class="cart-count"><?php echo $cart_count; ?></span>
            </a>
        </div>

    </div>
</header>

<main>
    <br>