<?php
session_start();

// اگر سبد خرید خالی بود
if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
    header("Location: cart.php");
    exit;
}

include '../admin/config/db.php';
include 'includes/header.php';
?>

<style>
.checkout-container {
    max-width: 600px;
    margin: 40px auto;
    background: #ffffff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 0 20px rgba(0,0,0,0.1);
    direction: rtl;
}

.checkout-container h2 {
    text-align: center;
    margin-bottom: 25px;
    font-size: 26px;
    font-weight: bold;
}

.checkout-container label {
    font-weight: bold;
    margin-top: 15px;
    display: block;
}

.checkout-container input,
.checkout-container select,
.checkout-container textarea {
    width: 100%;
    padding: 12px;
    border-radius: 10px;
    border: 1px solid #ccc;
    margin-top: 5px;
    font-size: 16px;
}

.checkout-container textarea {
    resize: none;
}

.checkout-btn {
    width: 100%;
    background: #28a745;
    color: #fff;
    padding: 14px;
    border-radius: 10px;
    font-size: 18px;
    margin-top: 25px;
    border: none;
    cursor: pointer;
    transition: 0.2s;
}

.checkout-btn:hover {
    opacity: 0.85;
}
</style>

<div class="checkout-container">

    <h2>اطلاعات ارسال سفارش</h2>

    <form action="submit_order.php" method="POST">

        <label>نام</label>
        <input type="text" name="fname" required>

        <label>نام خانوادگی</label>
        <input type="text" name="lname" required>

        <label>شماره موبایل</label>
        <input type="text" name="phone" required>

        <label>استان</label>
        <select name="province" id="province" required>
            <option value="">انتخاب کنید</option>
            <option value="آذربایجان شرقی">آذربایجان شرقی</option>
            <option value="آذربایجان غربی">آذربایجان غربی</option>
            <option value="اردبیل">اردبیل</option>
            <option value="اصفهان">اصفهان</option>
            <option value="البرز">البرز</option>
            <option value="ایلام">ایلام</option>
            <option value="بوشهر">بوشهر</option>
            <option value="تهران">تهران</option>
            <option value="چهارمحال و بختیاری">چهارمحال و بختیاری</option>
            <option value="خراسان جنوبی">خراسان جنوبی</option>
            <option value="خراسان رضوی">خراسان رضوی</option>
            <option value="خراسان شمالی">خراسان شمالی</option>
            <option value="خوزستان">خوزستان</option>
            <option value="زنجان">زنجان</option>
            <option value="سمنان">سمنان</option>
            <option value="سیستان و بلوچستان">سیستان و بلوچستان</option>
            <option value="فارس">فارس</option>
            <option value="قزوین">قزوین</option>
            <option value="قم">قم</option>
            <option value="کردستان">کردستان</option>
            <option value="کرمان">کرمان</option>
            <option value="کرمانشاه">کرمانشاه</option>
            <option value="کهگیلویه و بویراحمد">کهگیلویه و بویراحمد</option>
            <option value="گلستان">گلستان</option>
            <option value="گیلان">گیلان</option>
            <option value="لرستان">لرستان</option>
            <option value="مازندران">مازندران</option>
            <option value="مرکزی">مرکزی</option>
            <option value="هرمزگان">هرمزگان</option>
            <option value="همدان">همدان</option>
            <option value="یزد">یزد</option>
        </select>

        <label>شهر</label>
        <select name="city" id="city" required>
            <option value="">ابتدا استان را انتخاب کنید</option>
        </select>

        <label>آدرس دقیق</label>
        <textarea name="address" rows="4" required></textarea>

        <button class="checkout-btn" type="submit">ثبت سفارش</button>

    </form>

</div>

<script>
const cities = {
    "آذربایجان شرقی": ["تبریز", "مراغه", "مرند", "اهر", "شبستر"],
    "آذربایجان غربی": ["ارومیه", "خوی", "میاندوآب", "بوکان"],
    "اردبیل": ["اردبیل", "مشگین‌شهر", "پارس‌آباد"],
    "اصفهان": ["اصفهان", "کاشان", "خمینی‌شهر", "نجف‌آباد"],
    "البرز": ["کرج", "فردیس", "نظرآباد"],
    "ایلام": ["ایلام", "دهلران", "آبدانان"],
    "بوشهر": ["بوشهر", "برازجان", "کنگان"],
    "تهران": ["تهران", "ری", "اسلامشهر", "شهریار", "پردیس"],
    "چهارمحال و بختیاری": ["شهرکرد", "بروجن"],
    "خراسان جنوبی": ["بیرجند", "قائن"],
    "خراسان رضوی": ["مشهد", "نیشابور", "سبزوار"],
    "خراسان شمالی": ["بجنورد", "شیروان"],
    "خوزستان": ["اهواز", "آبادان", "خرمشهر", "دزفول"],
    "زنجان": ["زنجان", "ابهر"],
    "سمنان": ["سمنان", "شاهرود"],
    "سیستان و بلوچستان": ["زاهدان", "چابهار", "زابل"],
    "فارس": ["شیراز", "مرودشت", "کازرون"],
    "قزوین": ["قزوین", "البرز"],
    "قم": ["قم"],
    "کردستان": ["سنندج", "سقز", "بانه"],
    "کرمان": ["کرمان", "رفسنجان", "جیرفت"],
    "کرمانشاه": ["کرمانشاه", "اسلام‌آباد غرب"],
    "کهگیلویه و بویراحمد": ["یاسوج", "دهدشت"],
    "گلستان": ["گرگان", "گنبد کاووس"],
    "گیلان": ["رشت", "انزلی", "لاهیجان"],
    "لرستان": ["خرم‌آباد", "بروجرد"],
    "مازندران": ["ساری", "آمل", "بابل"],
    "مرکزی": ["اراک", "ساوه"],
    "هرمزگان": ["بندرعباس", "قشم", "بندر لنگه"],
    "همدان": ["همدان", "ملایر"],
    "یزد": ["یزد", "میبد", "اردکان"]
};

document.getElementById("province").addEventListener("change", function () {
    const province = this.value;
    const citySelect = document.getElementById("city");

    citySelect.innerHTML = "<option value=''>انتخاب شهر</option>";

    if (cities[province]) {
        cities[province].forEach(function (city) {
            const option = document.createElement("option");
            option.value = city;
            option.textContent = city;
            citySelect.appendChild(option);
        });
    }
});
</script>

<?php include 'includes/footer.php'; ?>