<<?php
session_start();
include '../admin/config/db.php';

// اگر سبد وجود نداشت، بساز
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

/* ------------------ افزودن محصول ------------------ */
if (isset($_GET['add'])) {
    $id = intval($_GET['add']);

    if (isset($_SESSION['cart'][$id])) {
        $_SESSION['cart'][$id]++;
    } else {
        $_SESSION['cart'][$id] = 1;
    }

    header("Location: cart.php");
    exit;
}

/* ------------------ کم کردن تعداد ------------------ */
if (isset($_GET['minus'])) {
    $id = intval($_GET['minus']);

    if (isset($_SESSION['cart'][$id])) {
        if ($_SESSION['cart'][$id] > 1) {
            $_SESSION['cart'][$id]--;
        } else {
            unset($_SESSION['cart'][$id]);
        }
    }

    header("Location: cart.php");
    exit;
}

/* ------------------ حذف کامل ------------------ */
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);

    if (isset($_SESSION['cart'][$id])) {
        unset($_SESSION['cart'][$id]);
    }

    header("Location: cart.php");
    exit;
}

/* ------------------ پاکسازی سبد از محصولات حذف‌شده ------------------ */
foreach ($_SESSION['cart'] as $pid => $qty) {
    $check = $pdo->prepare("SELECT id FROM products WHERE id = ?");
    $check->execute([$pid]);

    if ($check->rowCount() == 0) {
        unset($_SESSION['cart'][$pid]);
    }
}

/* ------------------ گرفتن محصولات ------------------ */
$items = [];
$total = 0;

if (!empty($_SESSION['cart'])) {
    $ids = implode(",", array_keys($_SESSION['cart']));
    $stmt = $pdo->query("SELECT * FROM products WHERE id IN ($ids)");
    $items = $stmt->fetchAll();
}

include 'includes/header.php';
?>
<style>
.qty-box {
    display: flex;
    align-items: center;
    gap: 10px;
}

.qty-btn {
    display: inline-flex;
    justify-content: center;
    align-items: center;
    width: 35px;
    height: 35px;
    font-size: 22px;
    font-weight: bold;
    border-radius: 8px;
    text-decoration: none;
    color: #fff;
    transition: 0.2s;
}

.qty-btn.plus {
    background: #28a745;
}

.qty-btn.minus {
    background: #dc3545;
}

.qty-btn:hover {
    opacity: 0.8;
}

.qty-number {
    font-size: 20px;
    font-weight: bold;
    min-width: 25px;
    text-align: center;
    display: inline-block;
}
</style>

<div class="cart-container">

    <h2>سبد خرید</h2>

    <?php if (empty($items)): ?>
        <p>سبد خرید خالی است.</p>

    <?php else: ?>

        <table class="cart-table">
            <tr>
                <th>عکس</th>
                <th>محصول</th>
                <th>قیمت واحد</th>
                <th>تعداد</th>
                <th>قیمت کل</th>
                <th>عملیات</th>
            </tr>

            <?php foreach ($items as $p): ?>

<?php
// گرفتن عکس محصول
$img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
$img->execute([$p['id']]);
$image = $img->fetchColumn();

// تعداد
$qty = $_SESSION['cart'][$p['id']];

// قیمت امن (اگر final_price خالی بود → price را بگیر)
$unit_price = 0;

if (!empty($p['final_price'])) {
    $unit_price = (float)$p['final_price'];
} elseif (!empty($p['price'])) {
    $unit_price = (float)$p['price'];
}

// جمع قیمت
$sum = $qty * $unit_price;

// جمع کل
$total += $sum;
?>

<tr>
    <td>
        <img src="../admin/<?php echo $image; ?>" width="80" style="border-radius:8px;">
    </td>

    <td><?php echo $p['title']; ?></td>

    <td><?php echo number_format($unit_price); ?> تومان</td>

    <td>
        <div class="qty-box">
            <a class="qty-btn minus" href="cart.php?minus=<?php echo $p['id']; ?>">−</a>
            <span class="qty-number"><?php echo $qty; ?></span>
            <a class="qty-btn plus" href="cart.php?add=<?php echo $p['id']; ?>">+</a>
        </div>
    </td>

    <td><?php echo number_format($sum); ?> تومان</td>

    <td>
        <a class="delete-btn" href="cart.php?delete=<?php echo $p['id']; ?>">حذف</a>
    </td>
</tr>

<?php endforeach; ?>

        </table>

        <h3 class="total-price">جمع کل: <?php echo number_format($total); ?> تومان</h3>

        <a href="checkout.php" class="checkout-btn">تسویه حساب</a>

    <?php endif; ?>

</div>

<?php include 'includes/footer.php'; ?>