<?php
require '../admin/config/db.php';
include 'includes/header.php';

// گرفتن پست‌ها از دیتابیس
$posts = $pdo->query("SELECT * FROM blog_posts ORDER BY id DESC")->fetchAll();
?>
<style>
    /* --- صفحه وبلاگ حرفه‌ای --- */

.blog-container {
    width: 90%;
    max-width: 1100px;
    margin: 50px auto;
    padding-bottom: 50px;
}

.blog-title {
    text-align: center;
    font-size: 36px;
    font-weight: bold;
    color: #d4af37;
    margin-bottom: 40px;
    letter-spacing: 1px;
    text-shadow: 0 0 8px rgba(212,175,55,0.3);
}

/* --- باکس هر پست --- */
.blog-post {
    background: #ffffff;
    padding: 30px;
    border-radius: 16px;
    margin-bottom: 45px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.08);
    transition: 0.3s ease;
    border: 1px solid #eee;
}

.blog-post:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.12);
}

/* --- عنوان پست --- */
.post-title {
    font-size: 28px;
    font-weight: bold;
    color: #333;
    margin-bottom: 20px;
    border-right: 4px solid #d4af37;
    padding-right: 10px;
}

/* --- عکس پست --- */
.post-image {
    width: 100%;
    border-radius: 14px;
    margin: 20px 0;
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
    transition: 0.3s ease;
}

.post-image:hover {
    transform: scale(1.03);
}

/* --- متن پست --- */
.post-text {
    font-size: 18px;
    line-height: 2.2;
    color: #444;
    margin-top: 10px;
    text-align: justify;
}

/* --- ریسپانسیو موبایل --- */
@media (max-width: 768px) {
    .blog-title {
        font-size: 28px;
    }

    .post-title {
        font-size: 22px;
    }

    .blog-post {
        padding: 20px;
    }
}
</style>

<div class="blog-container">

    <h1 class="blog-title">وبلاگ فروشگاه</h1>

    <?php if (empty($posts)): ?>
        <p style="text-align:center; margin-top:30px;">هنوز هیچ مطلبی ثبت نشده.</p>
    <?php endif; ?>

    <?php foreach ($posts as $post): ?>

        <div class="blog-post">

            <h2 class="post-title"><?php echo $post['title']; ?></h2>

            <?php if (!empty($post['image_path'])): ?>
                <img src="../admin/<?php echo $post['image_path']; ?>" class="post-image">
            <?php endif; ?>

            <p class="post-text">
                <?php echo nl2br($post['content']); ?>
            </p>

        </div>

    <?php endforeach; ?>

</div>

<?php include 'includes/footer.php'; ?>