<?php
header("Content-Type: application/json");

// گرفتن قیمت از TGJU با CURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.tgju.org/v1/market/summary");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // مهم برای WAMP
$response = curl_exec($ch);
curl_close($ch);

// اگر API جواب نداد
if (!$response) {
    echo json_encode(["error" => "no_response"]);
    exit;
}

$json = json_decode($response, true);

// اگر ساختار API تغییر کرده بود
if (!isset($json['results']['geram18']['p']) || !isset($json['results']['geram24']['p'])) {
    echo json_encode(["error" => "invalid_structure"]);
    exit;
}

// قیمت‌ها رشته با کاما هستند → باید پاک شوند
$g18 = str_replace(",", "", $json['results']['geram18']['p']);
$g24 = str_replace(",", "", $json['results']['geram24']['p']);

// تبدیل به عدد
$g18 = intval($g18);
$g24 = intval($g24);

// خروجی نهایی
echo json_encode([
    "g18" => $g18,
    "g24" => $g24
]);
?>