<?php
session_start();
include '../admin/config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = (int)$_SESSION['user_id'];
$message = "";

// اگر فرم ارسال شد
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $address = trim($_POST['address'] ?? '');

    if ($address === "") {
        $message = " لطفاً آدرس را وارد کنید. اسم استان وشهر تون";
    } else {
        $stmt = $pdo->prepare("INSERT INTO addresses (user_id, address) VALUES (?, ?)");
        $stmt->execute([$user_id, $address]);

        $message = "آدرس با موفقیت ثبت شد.";
    }
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
<title>افزودن آدرس</title>

<style>
@font-face {
    font-family: "Vazir";
    src: url("https://cdn.font-store.ir/fonts/vazir/Vazir.woff2") format("woff2");
}

body {
    background: #0d0d0d;
    color: #fff;
    font-family: "Vazir", Tahoma;
    direction: rtl;
    margin: 0;
}

.container {
    width: 60%;
    margin: 120px auto;
    background: #111;
    padding: 30px;
    border-radius: 12px;
    box-shadow: 0 0 20px rgba(255, 215, 0, 0.3);
}

h2 {
    color: #FFD700;
    border-right: 4px solid #FFD700;
    padding-right: 10px;
}

textarea {
    width: 100%;
    height: 120px;
    background: #1a1a1a;
    border: 2px solid #333;
    border-radius: 8px;
    padding: 10px;
    color: #fff;
    font-size: 16px;
    resize: none;
}

textarea:focus {
    border-color: #FFD700;
    outline: none;
}

.btn {
    display: inline-block;
    padding: 10px 20px;
    background: #FFD700;
    color: #000;
    border-radius: 8px;
    text-decoration: none;
    font-weight: bold;
    margin-top: 15px;
    transition: 0.3s;
}

.btn:hover {
    background: #fff;
}

.message {
    background: #222;
    padding: 12px;
    border-right: 4px solid #FFD700;
    margin-bottom: 15px;
    border-radius: 8px;
}

.back {
    display: inline-block;
    margin-top: 20px;
    color: #FFD700;
    text-decoration: none;
}
</style>
</head>
<body>

<div class="container">
    <h2>افزودن آدرس جدید</h2>

    <?php if ($message): ?>
        <div class="message"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="POST">
        <label>آدرس کامل:</label>
        <textarea name="address" placeholder="آدرس خود را وارد کنید استان وشهرتون دقیق..."></textarea>

        <br><br>
        <button class="btn" type="submit">ثبت آدرس</button>
    </form>

    <a class="back" href="profile.php#addresses">← بازگشت به پروفایل</a>
</div>

</body>
</html>