<?php
$page_title = "تغییر وضعیت سفارش";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';


// فقط از طریق POST باید صدا زده شود
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("دسترسی نامعتبر");
}

// گرفتن اطلاعات
$id = $_POST['id'] ?? null;
$status = $_POST['status'] ?? null;

// بررسی معتبر بودن
if (!$id || !$status) {
    die("اطلاعات ناقص است");
}

// آپدیت وضعیت
$update = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ?");
$update->execute([$status, $id]);

// گرفتن سفارش آپدیت‌شده
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id = ?");
$stmt->execute([$id]);
$order = $stmt->fetch();
?>

<style>
.update-box {
    max-width: 600px;
    margin: 40px auto;
    background: #fff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    text-align: center;
}

.update-box h2 {
    font-size: 24px;
    margin-bottom: 15px;
}

.success-msg {
    background: #28a745;
    color: #fff;
    padding: 12px;
    border-radius: 10px;
    margin-bottom: 20px;
    font-size: 18px;
}

.order-info {
    background: #f7f7f7;
    padding: 15px;
    border-radius: 10px;
    margin-top: 15px;
    text-align: right;
}

.btn-back {
    display: inline-block;
    margin-top: 20px;
    padding: 12px 25px;
    background: #007bff;
    color: #fff;
    border-radius: 10px;
    text-decoration: none;
    font-size: 16px;
}
</style>

<div class="content">

    <div class="update-box">

        <div class="success-msg">
            وضعیت سفارش با موفقیت تغییر کرد
        </div>

        <h2>سفارش شماره <?= $order['id'] ?></h2>

        <div class="order-info">
            <p><strong>نام مشتری:</strong> <?= $order['fname'] . " " . $order['lname'] ?></p>
            <p><strong>وضعیت جدید:</strong> <?= $order['status'] ?></p>
            <p><strong>مبلغ:</strong> <?= number_format($order['total_price']) ?> تومان</p>
        </div>

        <a href="orders_list.php" class="btn-back">بازگشت به لیست سفارش‌ها</a>

    </div>

</div>

<?php require 'includes/footer.php'; ?>