<?php
$page_title = "تنظیمات فروشگاه";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name    = $_POST['store_name'];
    $phone   = $_POST['phone'];
    $address = $_POST['address'];
    $about   = $_POST['about'];
    $instagram = $_POST['instagram'];
    $telegram  = $_POST['telegram'];

    $stmt = $pdo->prepare("
        UPDATE store_info SET 
        store_name = ?, phone = ?, address = ?, about = ?, instagram = ?, telegram = ?
        WHERE id = 1
    ");

    $stmt->execute([$name, $phone, $address, $about, $instagram, $telegram]);

    echo "<p>تنظیمات با موفقیت ذخیره شد.</p>";
}

$info = $pdo->query("SELECT * FROM store_info WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
?>

<h1>تنظیمات فروشگاه</h1>

<form action="" method="post">

    <label>نام فروشگاه:</label>
    <input type="text" name="store_name" value="<?php echo $info['store_name']; ?>" required>

    <label>شماره تماس:</label>
    <input type="text" name="phone" value="<?php echo $info['phone']; ?>" required>

    <label>آدرس:</label>
    <textarea name="address" rows="2"><?php echo $info['address']; ?></textarea>

    <label>درباره ما:</label>
    <textarea name="about" rows="4"><?php echo $info['about']; ?></textarea>

    <label>اینستاگرام:</label>
    <input type="text" name="instagram" value="<?php echo $info['instagram']; ?>">

    <label>تلگرام:</label>
    <input type="text" name="telegram" value="<?php echo $info['telegram']; ?>">

    <button type="submit">ذخیره تنظیمات</button>
</form>

<?php
require 'includes/footer.php';