<?php
$page_title = "تنظیمات فروشگاه";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

// گرفتن تنظیمات فعلی
$stmt = $pdo->query("SELECT * FROM settings LIMIT 1");
$settings = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $store_name = $_POST['store_name'];
    $phone      = $_POST['phone'];
    $address    = $_POST['address'];
    $status     = $_POST['status'];

    // ذخیره در دیتابیس
    $stmt = $pdo->prepare("
        UPDATE settings SET
            store_name = :store_name,
            phone = :phone,
            address = :address,
            status = :status
        WHERE id = 1
    ");

    $stmt->execute([
        ':store_name' => $store_name,
        ':phone'      => $phone,
        ':address'    => $address,
        ':status'     => $status
    ]);

    echo "<p style='color:green;font-weight:bold;'>✔ تنظیمات با موفقیت ذخیره شد.</p>";
}
?>

<h1>تنظیمات فروشگاه</h1>

<form method="post">

    <label>نام فروشگاه:</label>
    <input type="text" name="store_name" value="<?php echo $settings['store_name']; ?>">

    <label>شماره تماس:</label>
    <input type="text" name="phone" value="<?php echo $settings['phone']; ?>">

    <label>آدرس:</label>
    <textarea name="address" rows="3"><?php echo $settings['address']; ?></textarea>

    <label>وضعیت فروشگاه:</label>
    <select name="status">
        <option value="active"   <?php if ($settings['status'] == 'active') echo 'selected'; ?>>فعال</option>
        <option value="inactive" <?php if ($settings['status'] == 'inactive') echo 'selected'; ?>>غیرفعال</option>
    </select>

    <button type="submit">ذخیره تنظیمات</button>

</form>

<?php require 'includes/footer.php'; ?>