<?php
$page_title = "لیست محصولات";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

$stmt = $pdo->query("SELECT * FROM products ORDER BY id DESC");
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<h1>لیست محصولات</h1>

<table border="1" cellpadding="10">
    <tr>
        <th>عکس</th>
        <th>عنوان</th>
        <th>قیمت</th>
        <th>وزن</th>
        <th>عملیات</th>
    </tr>

    <?php foreach ($products as $p): ?>

        <?php
        // گرفتن اولین عکس محصول
        $img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
        $img->execute([$p['id']]);
        $image = $img->fetchColumn();
        ?>

        <tr>
            <td>
                <?php if ($image): ?>
                    <img src="<?php echo $image; ?>" width="80" style="border-radius:8px;">
                <?php else: ?>
                    بدون عکس
                <?php endif; ?>
            </td>

            <td><?php echo htmlspecialchars($p['title']); ?></td>
            <td><?php echo $p['final_price']; ?></td>
            <td><?php echo $p['weight_gram']; ?></td>

            <td>
                
                <a href="product_delete.php?id=<?php echo $p['id']; ?>" onclick="return confirm('حذف شود؟');">حذف</a>
            </td>
        </tr>

    <?php endforeach; ?>
</table>

<?php
require 'includes/footer.php';