<?php
require 'check_admin.php';
require 'config/db.php';

if (!isset($_GET['id'])) {
    die("شناسه محصول نامعتبر است.");
}

$id = intval($_GET['id']);

// گرفتن عکس‌های محصول
$stmt = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ?");
$stmt->execute([$id]);
$images = $stmt->fetchAll(PDO::FETCH_ASSOC);

// حذف عکس‌ها از سرور
foreach ($images as $img) {
    if (!empty($img['image_path']) && file_exists($img['image_path'])) {
        unlink($img['image_path']);
    }
}

// حذف عکس‌ها از دیتابیس
$pdo->prepare("DELETE FROM product_images WHERE product_id = ?")->execute([$id]);

// حذف محصول از دیتابیس
$pdo->prepare("DELETE FROM products WHERE id = ?")->execute([$id]);

// برگشت به لیست محصولات
header("Location: products_list.php");
exit;