<?php
$page_title = "مدیریت سفارش‌ها";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

$orders = $pdo->query("SELECT * FROM orders ORDER BY id DESC")->fetchAll();
?>

<style>
.table-box {
    background: #fff;
    padding: 25px;
    border-radius: 15px;
    margin: 20px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
}

table {
    width: 100%;
    border-collapse: collapse;
}

table th, table td {
    padding: 12px;
    border-bottom: 1px solid #ddd;
    text-align: center;
    vertical-align: top;
}

.customer-info {
    text-align: right;
    white-space: normal;
    max-width: 260px;
    line-height: 1.8;
    font-size: 14px;
}

.status {
    padding: 6px 12px;
    border-radius: 8px;
    font-weight: bold;
    display: inline-block;
}

.status.waiting { background: #ffc107; }
.status.packing { background: #17a2b8; color: #fff; }
.status.sent { background: #28a745; color: #fff; }
.status.delivered { background: #6f42c1; color: #fff; }

.status-select {
    padding: 8px 12px;
    border-radius: 8px;
    border: 1px solid #ccc;
}

.btn-status {
    padding: 8px 12px;
    background: #007bff;
    color: #fff;
    border-radius: 8px;
    border: none;
    cursor: pointer;
}
</style>

<div class="content">

<div class="table-box">
    <h2>مدیریت سفارش‌ها</h2>

    <table>
        <tr>
            <th>شماره</th>
            <th>اطلاعات مشتری</th>
            <th>مبلغ</th>
            <th>وضعیت</th>
            <th>تغییر وضعیت</th>
        </tr>

        <?php foreach ($orders as $o): ?>
        <tr>
            <td><?= $o['id'] ?></td>

            <td class="customer-info">
                <strong>نام:</strong> <?= $o['fname'] . ' ' . $o['lname'] ?><br>
                <strong>تلفن:</strong> <?= $o['phone'] ?><br>
                <strong>استان:</strong> <?= $o['province'] ?><br>
                <strong>شهر:</strong> <?= $o['city'] ?><br>
                <strong>آدرس:</strong> <?= $o['address'] ?>
            </td>

            <td><?= number_format($o['total_price']) ?> تومان</td>

            <td>
                <span class="status 
                    <?php 
                        if ($o['status'] == 'ارسال شده') echo 'sent';
                        elseif ($o['status'] == 'بسته بندی') echo 'packing';
                        elseif ($o['status'] == 'تحویل شده') echo 'delivered';
                        else echo 'waiting';
                    ?>
                ">
                    <?= $o['status'] ?>
                </span>
            </td>

            <td>
                <form method="POST" action="update_status.php" style="display:flex; gap:10px; justify-content:center;">
                    <input type="hidden" name="id" value="<?= $o['id'] ?>">

                    <select name="status" class="status-select">
                        <option value="در حال پردازش" <?= $o['status']=="در حال پردازش"?"selected":"" ?>>در حال پردازش</option>
                        <option value="بسته بندی" <?= $o['status']=="بسته بندی"?"selected":"" ?>>بسته بندی</option>
                        <option value="ارسال شده" <?= $o['status']=="ارسال شده"?"selected":"" ?>>ارسال شده</option>
                        <option value="تحویل شده" <?= $o['status']=="تحویل شده"?"selected":"" ?>>تحویل شده</option>
                    </select>

                    <button class="btn-status" type="submit">ثبت</button>
                </form>
            </td>
        </tr>
        <?php endforeach; ?>

    </table>
</div>

</div>

<?php require 'includes/footer.php'; ?>