<?php
$page_title = "مدیریت سفارش‌ها";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';
$orders = $pdo->query("SELECT * FROM orders ORDER BY id DESC")->fetchAll();
?>

<style>
.table-box {
    background: #fff;
    padding: 25px;
    border-radius: 15px;
    margin: 20px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
}

table {
    width: 100%;
    border-collapse: collapse;
}

table th, table td {
    padding: 12px;
    border-bottom: 1px solid #ddd;
}

.status {
    padding: 5px 10px;
    border-radius: 8px;
    font-weight: bold;
}

.status.waiting { background: #ffc107; }
.status.packing { background: #17a2b8; color: #fff; }
.status.sent { background: #28a745; color: #fff; }
.status.delivered { background: #6f42c1; color: #fff; }

.btn-edit {
    padding: 8px 15px;
    background: #007bff;
    color: #fff;
    border-radius: 8px;
    text-decoration: none;
}
</style>

<div class="table-box">
    <h2>مدیریت سفارش‌ها</h2>

    <table>
        <tr>
            <th>شماره</th>
            <th>نام</th>
            <th>مبلغ</th>
            <th>وضعیت</th>
            <th>تاریخ</th>
            <th>عملیات</th>
        </tr>

        <?php foreach ($orders as $o): ?>
        <tr>
            <td><?= $o['id'] ?></td>
            <td><?= $o['fname'] . ' ' . $o['lname'] ?></td>
            <td><?= number_format($o['total_price']) ?> تومان</td>

            <td>
                <span class="status 
                    <?php 
                        if ($o['status'] == 'ارسال شده') echo 'sent';
                        elseif ($o['status'] == 'بسته بندی') echo 'packing';
                        elseif ($o['status'] == 'تحویل شده') echo 'delivered';
                        else echo 'waiting';
                    ?>
                ">
                    <?= $o['status'] ?>
                </span>
            </td>

            <td><?= $o['created_at'] ?></td>

            <td>
                <a class="btn-edit" href="update_status.php?id=<?= $o['id'] ?>">تغییر وضعیت</a>
            </td>
        </tr>
        <?php endforeach; ?>

    </table>
</div>

<?php require 'includes/footer.php'; ?>