<?php
$page_title = "محصولات شگفت‌انگیز";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';
$stmt = $pdo->query("SELECT * FROM products WHERE is_special = 1 ORDER BY id DESC");
$offers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<h1>محصولات شگفت‌انگیز</h1>

<table border="1" cellpadding="10">
    <tr>
        <th>عکس</th>
        <th>عنوان</th>
        <th>قیمت اصلی</th>
        <th>تخفیف (%)</th>
        <th>قیمت نهایی</th>
    </tr>

    <?php foreach ($offers as $p): ?>

        <?php
        $img = $pdo->prepare("SELECT image_path FROM product_images WHERE product_id = ? LIMIT 1");
        $img->execute([$p['id']]);
        $image = $img->fetchColumn();
        ?>

        <tr>
            <td>
                <?php if ($image): ?>
                    <img src="<?php echo $image; ?>" width="80">
                <?php else: ?>
                    بدون عکس
                <?php endif; ?>
            </td>

            <td><?php echo htmlspecialchars($p['title']); ?></td>
            <td><?php echo $p['final_price']; ?></td>
            <td><?php echo $p['discount_percent']; ?></td>
            <td><?php echo $p['discounted_price']; ?></td>
        </tr>

    <?php endforeach; ?>
</table>

<?php
require 'includes/footer.php';