<?php
$page_title = "افزودن محصول شگفت‌انگیز";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

$success_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // گرفتن مقادیر فرم
    $title       = isset($_POST['title']) ? trim($_POST['title']) : '';
    $description = isset($_POST['description']) ? trim($_POST['description']) : '';
    $price       = isset($_POST['price']) && $_POST['price'] !== '' ? (int)$_POST['price'] : 0;

    // ذخیره محصول فقط با قیمت دستی
    $stmt = $pdo->prepare("
        INSERT INTO products 
        (title, description, price, is_special)
        VALUES (?, ?, ?, 1)
    ");
    $stmt->execute([$title, $description, $price]);

    $product_id = $pdo->lastInsertId();

    // آپلود تصاویر (در صورت وجود)
    if (!empty($_FILES['images']['name'][0])) {
        $upload_dir = 'uploads/products/';

        $imgStmt = $pdo->prepare("INSERT INTO product_images (product_id, image_path) VALUES (?, ?)");

        foreach ($_FILES['images']['name'] as $key => $name) {
            $tmp = $_FILES['images']['tmp_name'][$key] ?? null;

            if ($tmp && is_uploaded_file($tmp)) {
                $ext = pathinfo($name, PATHINFO_EXTENSION);
                $new_name = "offer_{$product_id}_" . time() . "_$key.$ext";
                $dest = $upload_dir . $new_name;

                if (move_uploaded_file($tmp, $dest)) {
                    $imgStmt->execute([$product_id, $dest]);
                }
            }
        }
    }

    // جلوگیری از ثبت تکراری در اثر رفرش
    header("Location: offers_add.php?success=1");
    exit;
}

// پیام موفقیت بعد از ریدایرکت
if (isset($_GET['success']) && $_GET['success'] == 1) {
    $success_message = "محصول شگفت‌انگیز با موفقیت ثبت شد.";
}
?>

<h1>افزودن محصول شگفت‌انگیز</h1>

<?php if ($success_message): ?>
    <p style="color: green;"><?php echo $success_message; ?></p>
<?php endif; ?>

<form action="" method="post" enctype="multipart/form-data">

    <label>عنوان محصول:</label>
    <input type="text" name="title" required>

    <label>توضیحات:</label>
    <textarea name="description" rows="4"></textarea>

    <label>قیمت محصول (تومان):</label>
    <input type="number" name="price" required>

    <label>تصاویر محصول:</label>
    <input type="file" name="images[]" multiple>

    <button type="submit">ثبت محصول</button>
</form>

<?php
require 'includes/footer.php';
?>