<?php
session_start();
require 'config/db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['full_name'];
    $pass = $_POST['password'];

    // خواندن از جدول users بر اساس full_name
    $stmt = $pdo->prepare("SELECT * FROM users WHERE full_name = ?");
    $stmt->execute([$user]);
    $admin = $stmt->fetch();

    if ($admin) {
        $db_pass = $admin['password'];

        // اگر رمز هش شده بود
        if (strlen($db_pass) > 40) {
            $is_valid = password_verify($pass, $db_pass);
        } 
        // اگر رمز ساده بود
        else {
            $is_valid = ($pass === $db_pass);
        }

        if ($is_valid) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_id'] = $admin['id'];
            header("Location: dashboard.php");
            exit;
        }
    }

    $error = "نام یا رمز عبور اشتباه است";
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>ورود به پنل مدیریت</title>
<style>
body { font-family: sans-serif; background: #f5f5f5; }
.login-box { max-width: 400px; margin: 80px auto; background: #fff; padding: 25px; border-radius: 15px; box-shadow: 0 0 15px rgba(0,0,0,0.1); }
.login-box h2 { text-align: center; margin-bottom: 20px; }
.login-box input { width: 100%; padding: 10px; margin-top: 10px; border-radius: 8px; border: 1px solid #ccc; }
.login-box button { width: 100%; padding: 10px; margin-top: 15px; border-radius: 8px; border: none; background: #007bff; color: #fff; font-size: 16px; cursor: pointer; }
.error { color: #d9534f; margin-top: 10px; text-align: center; }
</style>
</head>
<body>

<div class="login-box">
    <h2>ورود به پنل مدیریت</h2>

    <?php if ($error): ?>
        <div class="error"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <input type="text" name="full_name" placeholder="نام کامل" required>
        <input type="password" name="password" placeholder="رمز عبور" required>
        <button type="submit">ورود</button>
    </form>
</div>

</body>
</html>