
<?php


$page_title = "داشبورد";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

// آمارها


$orders_count   = $pdo->query("SELECT COUNT(*) FROM orders")->fetchColumn();
$users_count    = $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn();
$products_count = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();

// فروش کل
$total_sales = $pdo->query("SELECT SUM(total_price) FROM orders")->fetchColumn();
$total_sales = $total_sales ?: 0;

// فروش امروز
$today = date("Y-m-d");
$today_sales = $pdo->prepare("SELECT SUM(total_price) FROM orders WHERE DATE(created_at)=?");
$today_sales->execute([$today]);
$today_sales = $today_sales->fetchColumn();
$today_sales = $today_sales ?: 0;

// وضعیت سفارش‌ها
$processing = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='در حال پردازش'")->fetchColumn();
$packing    = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='بسته بندی'")->fetchColumn();
$sent       = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='ارسال شده'")->fetchColumn();
$delivered  = $pdo->query("SELECT COUNT(*) FROM orders WHERE status='تحویل شده'")->fetchColumn();

// آخرین سفارش‌ها
$latest_orders = $pdo->query("SELECT * FROM orders ORDER BY id DESC LIMIT 5")->fetchAll();
?>

<style>
.dashboard-container {
    padding: 20px;
}

.cards {
    display: flex;
    flex-wrap: wrap;
    gap: 20px;
}

.card-box {
    flex: 1;
    min-width: 230px;
    background: #fff;
    padding: 25px;
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
    text-align: center;
}

.card-box h3 {
    font-size: 18px;
    margin-bottom: 10px;
}

.card-box p {
    font-size: 22px;
    font-weight: bold;
}

.table-box {
    margin-top: 40px;
    background: #fff;
    padding: 25px;
    border-radius: 15px;
    box-shadow: 0 0 15px rgba(0,0,0,0.1);
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 15px;
}

table th, table td {
    padding: 12px;
    border-bottom: 1px solid #ddd;
}

.status {
    padding: 5px 10px;
    border-radius: 8px;
    font-weight: bold;
}

.status.waiting { background: #ffc107; }
.status.packing { background: #17a2b8; color: #fff; }
.status.sent { background: #28a745; color: #fff; }
.status.delivered { background: #6f42c1; color: #fff; }
</style>

<div class="dashboard-container">

    <h1>داشبورد مدیریت</h1>
    <div style="display:flex; gap:10px; margin-bottom:20px;">

<a href="../site/index.php" 
   style="padding:10px 20px; background:#28a745; color:#fff; text-decoration:none; border-radius:8px;">
   رفتن به سایت
</a>

<a href="logout.php" 
   style="padding:10px 20px; background:#dc3545; color:#fff; text-decoration:none; border-radius:8px;">
   خروج از پنل مدیریت
</a>

</div>
    <div class="cards">

        <div class="card-box">
            <h3>تعداد سفارش‌ها</h3>
            <p><?= $orders_count ?></p>
        </div>

        <div class="card-box">
            <h3>تعداد کاربران</h3>
            <p><?= $users_count ?></p>
        </div>

        <div class="card-box">
            <h3>تعداد محصولات</h3>
            <p><?= $products_count ?></p>
        </div>

        <div class="card-box">
            <h3>فروش کل</h3>
            <p><?= number_format($total_sales) ?> تومان</p>
        </div>

        <div class="card-box">
            <h3>فروش امروز</h3>
            <p><?= number_format($today_sales) ?> تومان</p>
        </div>

        <div class="card-box">
            <h3>در حال پردازش</h3>
            <p><?= $processing ?></p>
        </div>

        <div class="card-box">
            <h3>بسته بندی</h3>
            <p><?= $packing ?></p>
        </div>

        <div class="card-box">
            <h3>ارسال شده</h3>
            <p><?= $sent ?></p>
        </div>

        <div class="card-box">
            <h3>تحویل شده</h3>
            <p><?= $delivered ?></p>
        </div>

    </div>

    <div class="table-box">
        <h3>آخرین سفارش‌ها</h3>

        <table>
            <tr>
                <th>شماره</th>
                <th>نام</th>
                <th>مبلغ</th>
                <th>وضعیت</th>
                <th>تاریخ</th>
            </tr>

            <?php foreach ($latest_orders as $o): ?>

<tr>
                <td><?= $o['id'] ?></td>
                <td><?= $o['fname'] . ' ' . $o['lname'] ?></td>
                <td><?= number_format($o['total_price']) ?> تومان</td>
                <td>
                    <span class="status 
                        <?php 
                            if ($o['status'] == 'ارسال شده') echo 'sent';
                            elseif ($o['status'] == 'بسته بندی') echo 'packing';
                            elseif ($o['status'] == 'تحویل شده') echo 'delivered';
                            else echo 'waiting';
                        ?>
                    ">
                        <?= $o['status'] ?>
                    </span>
                </td>
                <td><?= $o['created_at'] ?></td>
            </tr>
            <?php endforeach; ?>

        </table>
    </div>

</div>

<?php require 'includes/footer.php'; ?>