<?php
session_start();
require 'config/db.php';

// اگر مدیر لاگین نکرده باشد
if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit;
}

$success = "";
$error = "";

// گرفتن اطلاعات مدیر
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['admin_id']]);
$admin = $stmt->fetch();

if (!$admin) {
    die("مدیر یافت نشد!");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $new_name = $_POST['full_name'];
    $new_pass = $_POST['password'];

    // تغییر نام
    if (!empty($new_name)) {
        $update = $pdo->prepare("UPDATE users SET full_name = ? WHERE id = ?");
        $update->execute([$new_name, $admin['id']]);
    }

    // تغییر رمز
    if (!empty($new_pass)) {
        $hash = password_hash($new_pass, PASSWORD_DEFAULT);
        $update = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
        $update->execute([$hash, $admin['id']]);
    }

    $success = "اطلاعات با موفقیت بروزرسانی شد.";
}
?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تغییر اطلاعات مدیر</title>
<style>
body { font-family: sans-serif; background: #f5f5f5; }
.box { max-width: 450px; margin: 50px auto; background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
input { width: 100%; padding: 10px; margin-top: 10px; border-radius: 8px; border: 1px solid #ccc; }
button { width: 100%; padding: 10px; margin-top: 15px; border-radius: 8px; border: none; background: #007bff; color: #fff; font-size: 16px; cursor: pointer; }
.success { background: #28a745; color: #fff; padding: 10px; border-radius: 8px; margin-bottom: 15px; }
</style>
</head>
<body>

<div class="box">
    <h2>تغییر نام و رمز مدیر</h2>

    <?php if ($success): ?>
        <div class="success"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST">
        <label>نام کامل جدید</label>
        <input type="text" name="full_name" value="<?= $admin['full_name'] ?>">

        <label>رمز عبور جدید</label>
        <input type="password" name="password" placeholder="اگر نمی‌خواهی تغییر کنی خالی بگذار">

        <button type="submit">ذخیره تغییرات</button>
    </form>
</div>

</body>
</html>