<?php
$page_title = "مدیریت وبلاگ";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

$stmt = $pdo->query("SELECT * FROM blog_posts ORDER BY id DESC");
$posts = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<h1>مدیریت وبلاگ</h1>

<style>
.blog-box {
    background: #1a1a1a;
    padding: 20px;
    margin-bottom: 25px;
    border-radius: 12px;
    border: 1px solid #333;
}

.blog-box img {
    width: 100%;
    max-width: 400px;
    border-radius: 10px;
    margin-bottom: 15px;
    display: block;
}

.blog-title {
    font-size: 26px;
    font-weight: bold;
    color: #d4af37;
    margin-bottom: 10px;
}

.blog-price {
    font-size: 18px;
    color: #00ff9d;
    margin-bottom: 10px;
}

.blog-content {
    margin-top: 10px;
    line-height: 1.9;
    font-size: 16px;
}

.blog-actions {
    margin-top: 15px;
}

.blog-actions a {
    padding: 8px 15px;
    border-radius: 6px;
    margin-right: 10px;
    font-weight: bold;
}

.delete-btn {
    background: #ff4d4d;
    color: #000;
}

.edit-btn {
    background: #d4af37;
    color: #000;
}
</style>

<?php foreach ($posts as $p): ?>
    <div class="blog-box">

        <?php if (!empty($p['image_path'])): ?>
            <img src="<?php echo $p['image_path']; ?>" alt="blog image">
        <?php endif; ?>

        <div class="blog-title">
            <?php echo htmlspecialchars($p['title']); ?>
        </div>

        <?php if (!empty($p['price'])): ?>
            <div class="blog-price">
                قیمت: <?php echo $p['price']; ?> تومان
            </div>
        <?php endif; ?>

        <div class="blog-content">
            <?php echo nl2br(htmlspecialchars($p['content'])); ?>
        </div>

        <div class="blog-actions">
            
            <a class="delete-btn" href="blog_delete.php?id=<?php echo $p['id']; ?>" onclick="return confirm('حذف شود؟');">حذف</a>
        </div>

        <div style="margin-top:10px; color:#888;">
            تاریخ: <?php echo $p['created_at']; ?>
        </div>
    </div>
<?php endforeach; ?>

<?php
require 'includes/footer.php';