<?php
$page_title = "ویرایش مطلب وبلاگ";
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

if (!isset($_GET['id'])) {
    die("شناسه مطلب نامعتبر است.");
}

$id = intval($_GET['id']);

// دریافت اطلاعات مطلب
$stmt = $pdo->prepare("SELECT * FROM blog_posts WHERE id = ?");
$stmt->execute([$id]);
$post = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$post) {
    die("مطلب یافت نشد.");
}

// اگر فرم ارسال شد
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $title   = $_POST['title'];
    $content = $_POST['content'];
    $price   = !empty($_POST['price']) ? $_POST['price'] : null;

    $image_path = $post['image_path'];

    // اگر عکس جدید آپلود شد
    if (!empty($_FILES['image']['name'])) {
        $upload_dir = 'uploads/blog/';
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $new_name = 'blog_' . time() . '.' . $ext;
        $dest = $upload_dir . $new_name;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {

            // حذف عکس قبلی
            if (!empty($image_path) && file_exists($image_path)) {
                unlink($image_path);
            }

            $image_path = $dest;
        }
    }

    // آپدیت دیتابیس
    $stmt = $pdo->prepare("
        UPDATE blog_posts 
        SET title = :title,
            content = :content,
            price = :price,
            image_path = :image_path
        WHERE id = :id
    ");

    $stmt->execute([
        ':title' => $title,
        ':content' => $content,
        ':price' => $price,
        ':image_path' => $image_path,
        ':id' => $id
    ]);

    echo "<p>مطلب با موفقیت ویرایش شد.</p>";
}
?>

<h1>ویرایش مطلب وبلاگ</h1>

<form action="" method="post" enctype="multipart/form-data">

    <label>عنوان:</label>
    <input type="text" name="title" value="<?php echo htmlspecialchars($post['title']); ?>" required>

    <label>قیمت (اختیاری):</label>
    <input type="number" step="0.01" name="price" value="<?php echo $post['price']; ?>">

    <label>متن:</label>
    <textarea name="content" rows="6" required><?php echo htmlspecialchars($post['content']); ?></textarea>

    <label>عکس فعلی:</label><br>
    <?php if (!empty($post['image_path'])): ?>
        <img src="<?php echo $post['image_path']; ?>" width="200" style="border-radius:8px; margin-bottom:10px;">
    <?php endif; ?>
    <br><br>

    <label>آپلود عکس جدید (اختیاری):</label>
    <input type="file" name="image">

    <button type="submit">ذخیره تغییرات</button>
</form>

<?php
require 'includes/footer.php';