<?php
require 'config/db.php';
require 'includes/header.php';
require 'includes/sidebar.php';
require 'check_admin.php';

// گرفتن بنر فعلی
$stmt = $pdo->query("SELECT * FROM site_banner WHERE id = 1");
$banner = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $image = $banner['image'];

    if (!empty($_FILES['image']['name'])) {

        $upload_dir = 'uploads/banner/';
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $newname = 'banner_' . time() . '.' . $ext;
        $dest = $upload_dir . $newname;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $dest)) {
            $image = $dest;
        }
    }

    $stmt = $pdo->prepare("UPDATE site_banner SET image = :image WHERE id = 1");
    $stmt->execute([':image' => $image]);

    echo "<p style='color:green;font-weight:bold;'>✔ بنر با موفقیت ذخیره شد.</p>";
}
?>

<h1>مدیریت بنر سایت</h1>

<form method="post" enctype="multipart/form-data">

    <label>آپلود بنر جدید:</label>
    <input type="file" name="image">

    <?php if ($banner['image']): ?>
        <p>بنر فعلی:</p>
        <img src="<?php echo $banner['image']; ?>" style="width:300px;border-radius:10px;">
    <?php endif; ?>

    <button type="submit">ذخیره</button>

</form>

<?php require 'includes/footer.php'; ?>